﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Obroty wg dokumentów</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

public class ParametryContext : ContextBase { 
	public ParametryContext(Context cx) : base(cx) {
	}
	
	bool storna = false;
	
	public bool PokazujStorna {
		get { return storna; }
		set { storna = value; }
	}
}

ParametryContext parametry;

[Context]
public ParametryContext Parametry {
	get { return parametry; }
	set { parametry = value; }
}

void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
	if (args.Deep==1) {
		DokumentHandlowy dokument = (DokumentHandlowy)args.Row;
        if (dokument.KierunekMagazynu==KierunekPartii.Rozchód) {
            string kontrahentHtml = dokument.Kontrahent != null ? HttpUtility.HtmlEncode(dokument.Kontrahent.ToString()) : "BRAK";
            Grid.GroupLine = string.Format("Data: {0}, Dokument: {1} {2}, Kontrahent: {3}",
				dokument.Data, dokument, dokument.DokumentHandlowyNumer, kontrahentHtml);
            args.Enumerable = dokument.Obroty;
        }
        else {
            args.Enumerable = new Obrot[0];            
        } 
		nr = 0;
	}
}

int nr = 0;

    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        Obrot o = (Obrot)args.Row;
        if (Parametry.PokazujStorna)
			args.VisibleRow = o.Korekta!=KorektaObrotu.StornoZasobu;
		else
			args.VisibleRow = o.Korekta==KorektaObrotu.Brak;
        if (args.VisibleRow)
			lp.EditValue = ++nr;
    }

    Soneta.Handel.DokumentyParams dparams;

    [Soneta.Business.Context]
    public Soneta.Handel.DokumentyParams DParams {
        get { return dparams; }
        set { dparams = value; }
    }
    
    protected void dc_ContextLoad(object sender, EventArgs e) {
        ReportHeader.Title += "Typ: <STRONG>" + Soneta.HTML.HtmlParser.HtmlEncode(DParams.FiltrTypu.ToString());
    }
</script>
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Obroty wg dokumentów - szczegóły|</STRONG>Kierunek:<STRONG> {0}|</STRONG>Magazyn:<STRONG> {1}, </STRONG>Okres:<STRONG> {2}|</STRONG>Definicja:<STRONG> {3}, </STRONG>Seria:<STRONG> {4}</STRONG>|Partia:<STRONG> {5}, </STRONG>"
				runat="server" DataMember0="DokumentyParams.Kierunek" DataMember1="DokumentyParams.Magazyn" DataMember2="DokumentyParams.OkresDat"
				DataMember3="DokumentyParams.Definicja" DataMember4="DokumentyParams.Seria" DataMember5="DokumentyParams.FiltrTypuPartii"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Magazyny.Obrot,Soneta.Handel" OnItemsGet="Grid_ItemsGet" OnBeforeRow="Grid_BeforeRow"
				ShowGroupSum="True" >
				<Columns>
					<ea:GridColumn runat="server" Width="4" Align="Right" Caption="Lp." ID="lp" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="8" DataMember="Towar.Kod" Caption="Towar~Kod" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" DataMember="Towar" Total="Info" Caption="Towar~Nazwa" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="6" DataMember="Korekta" Caption="Typ" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Ilosc" Caption="Ilość" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" DataMember="Przychod.Data" Caption="Przych&#243;d~Data" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="15" DataMember="Przychod.Dokument" Caption="Przych&#243;d~Dokument" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Przychod.Wartosc" Total="Sum" Caption="Przych&#243;d~Wartość"
						Format="{0:n}" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Rozchod.Wartosc" Total="Sum" Caption="Rozch&#243;d~Wartość"
						Format="{0:n}" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Marża" Total="Sum" Caption="Marża~Wartość"
						Format="{0:n}" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="7" Align="Right" DataMember="ProcentMarży" Caption="Marża~%" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn runat="server" Width="8" Align="Right" DataMember="MarżaJednostkowa" Caption="Marża~Jednost." Format="{0:n}" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

